/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.listeners.DropdownSelectionListener;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteExpandableComposite;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.catalogos.ComprobantesReembolso;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.ValoresComprobante;
import ec.gob.sri.dimm.ats.modelo.obj.compras.DetalleAirCompras;
import ec.gob.sri.dimm.ats.modelo.obj.compras.Reembolso;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.ui.ConstantesUI;
import ec.gob.sri.dimm.ats.ui.asistentes.compras.AsistenteEdicionCompras;
import ec.gob.sri.dimm.ats.ui.asistentes.compras.AsistenteNuevaCompra;
import ec.gob.sri.dimm.ats.ui.dialogos.compras.DialogoDetalleAirCompra;
import ec.gob.sri.dimm.ats.ui.dialogos.compras.DialogoReembolso;
import ec.gob.sri.dimm.ats.ui.dialogos.filtros.IdentificacionComprasFilter;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import ec.gob.sri.dimm.ats.ui.util.ValidadorComprobantes;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaCompras
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private DataBindingContext m_bindingContext;
    private Iva modeloDatos;
    private TransaccionCompra compraSeleccionada;
    private Reembolso reembolsoSelecionado;
    private DetalleAirCompras detalleSeleccionado;
    private Table table;
    private ToolItem tltmNuevoCompra;
    private Text txtIdentificacion;
    private Button btnBtnbuscar;
    private MenuItem tltmEditarProveedor;
    private ToolItem tltmEliminar;
    private TableViewer tvCompras;
    private Table table_2;
    private TableViewer tvReembolsos;
    private ToolItem tlINuevaRetencion;
    private ToolItem tlIEditarReembolso;
    private ToolItem tlmNuevoReembolso;
    private MenuItem tltmEditarComprobante;
    private MenuItem tltmEditarValores;
    private Menu menuEditar;
    private MenuItem tltmEditarPagocomprobanteRetencion;
    private MenuItem tltmEditarFormasDe;
    private ToolItem tliElminarReembolso;
    private ToolItem tltEditarRetencion;
    private ToolItem tltEliminarRetencion;
    private ExpandableComposite xcRetenciones;
    private ExpandableComposite xcReembolsos;
    private Table table_1;
    private TableViewer tvRetenciones;
    private IdentificacionComprasFilter filtroCompras;
    private Label lblRegistros;
    private Label lblTotalReembolso;
    private Label lblTotalReembolsos;

    public PaginaCompras(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnComprobantesAnulados = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnComprobantesAnulados);
        sctnComprobantesAnulados.setText("Compras");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnComprobantesAnulados, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnComprobantesAnulados.setClient((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        ExpandableComposite xcCompras = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xcCompras = new FormData();
        fd_xcCompras.left = new FormAttachment(0, 3);
        fd_xcCompras.top = new FormAttachment(0, 3);
        fd_xcCompras.bottom = new FormAttachment(0, 350);
        xcCompras.setLayoutData((Object)fd_xcCompras);
        managedForm.getToolkit().paintBordersFor((Composite)xcCompras);
        xcCompras.setText("Informaci\u00f3n de Compras por Proveedor");
        xcCompras.setExpanded(true);
        Composite cCompras = managedForm.getToolkit().createComposite((Composite)xcCompras, 0);
        xcCompras.setClient((Control)cCompras);
        managedForm.getToolkit().paintBordersFor(cCompras);
        cCompras.setLayout((Layout)new BorderLayout(0, 0));
        this.tvCompras = new TableViewer(cCompras, 67584);
        this.filtroCompras = new IdentificacionComprasFilter();
        this.filtroCompras.setSearchText("");
        this.tvCompras.addFilter((ViewerFilter)this.filtroCompras);
        this.tablaComprasSelectionChanged();
        this.table = this.tvCompras.getTable();
        this.table.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.table);
        TableColumn tblclmnNSustento = new TableColumn(this.table, 0);
        tblclmnNSustento.setWidth(150);
        tblclmnNSustento.setText("Sustento");
        TableColumn tblclmnNIdentificacin = new TableColumn(this.table, 0);
        tblclmnNIdentificacin.setWidth(120);
        tblclmnNIdentificacin.setText("N\u00b0 Identificaci\u00f3n");
        TableColumn tblclmnTipoDeComprobante = new TableColumn(this.table, 0);
        tblclmnTipoDeComprobante.setWidth(150);
        tblclmnTipoDeComprobante.setText("Tipo de Comprobante");
        TableColumn tblclmnCompVenta = new TableColumn(this.table, 0);
        tblclmnCompVenta.setWidth(100);
        tblclmnCompVenta.setText("Comp. Venta");
        TableColumn tblclmnAutorizacin = new TableColumn(this.table, 0);
        tblclmnAutorizacin.setWidth(100);
        tblclmnAutorizacin.setText("Autorizaci\u00f3n");
        TableColumn tblclmnBaseIva = new TableColumn(this.table, 0);
        tblclmnBaseIva.setWidth(78);
        tblclmnBaseIva.setText("Base IVA 0%");
        TableColumn tblclmnBaseIvaDiferente = new TableColumn(this.table, 0);
        tblclmnBaseIvaDiferente.setWidth(130);
        tblclmnBaseIvaDiferente.setText("Base IVA diferente 0%");
        TableColumn tblclmnBaseNoObjeto = new TableColumn(this.table, 0);
        tblclmnBaseNoObjeto.setWidth(120);
        tblclmnBaseNoObjeto.setText("Base No Objeto IVA");
        TableColumn tblclmnMontoIva = new TableColumn(this.table, 0);
        tblclmnMontoIva.setWidth(100);
        tblclmnMontoIva.setText("Monto IVA");
        Composite cCabecera = managedForm.getToolkit().createComposite(cCompras, 0);
        cCabecera.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(cCabecera);
        GridLayout gl_cCabecera = new GridLayout(4, false);
        gl_cCabecera.marginWidth = 0;
        gl_cCabecera.verticalSpacing = 1;
        cCabecera.setLayout((Layout)gl_cCabecera);
        ToolBar toolBar = new ToolBar(cCabecera, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 1, 1);
        gd_toolBar.widthHint = 720;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevoCompra = new ToolItem(toolBar, 0);
        this.tltmNuevoCompra.setText("Nuevo");
        ToolItem tltmEditar = new ToolItem(toolBar, 4);
        tltmEditar.setText("Editar");
        this.tltmEliminar = new ToolItem(toolBar, 0);
        this.tltmEliminar.setText("Eliminar");
        this.menuEditar = new Menu((Control)tltmEditar.getParent().getShell());
        this.tltmEditarProveedor = new MenuItem(this.menuEditar, 0);
        this.tltmEditarProveedor.setText("Editar Proveedor");
        this.tltmEditarComprobante = new MenuItem(this.menuEditar, 0);
        this.tltmEditarComprobante.setText("Editar Comprobante");
        this.tltmEditarValores = new MenuItem(this.menuEditar, 0);
        this.tltmEditarValores.setText("Editar Valores");
        this.tltmEditarPagocomprobanteRetencion = new MenuItem(this.menuEditar, 0);
        this.tltmEditarPagocomprobanteRetencion.setText("Editar Pago/Comprobante Retencion");
        this.tltmEditarFormasDe = new MenuItem(this.menuEditar, 0);
        this.tltmEditarFormasDe.setText("Editar Formas de Pago");
        DropdownSelectionListener dropListener = new DropdownSelectionListener(this.menuEditar);
        tltmEditar.addSelectionListener((SelectionListener)dropListener);
        Label lblNewLabel = new Label(cCabecera, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)lblNewLabel, true, true);
        lblNewLabel.setText("Filtrar por Identificacion:");
        this.txtIdentificacion = new Text(cCabecera, 2048);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtIdentificacion.widthHint = 114;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        this.txtIdentificacion.setBounds(0, 0, 76, 21);
        managedForm.getToolkit().adapt((Control)this.txtIdentificacion, true, true);
        this.btnBtnbuscar = new Button(cCabecera, 0);
        this.btnBtnbuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBtnbuscar, true, true);
        Composite cRegistros = new Composite(cCompras, 0);
        cRegistros.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(cRegistros);
        managedForm.getToolkit().paintBordersFor(cRegistros);
        cRegistros.setLayout((Layout)new GridLayout(1, false));
        this.lblRegistros = new Label(cRegistros, 0);
        GridData gd_lblRegistros = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegistros.widthHint = 500;
        this.lblRegistros.setLayoutData((Object)gd_lblRegistros);
        managedForm.getToolkit().adapt((Control)this.lblRegistros, true, true);
        this.xcRetenciones = managedForm.getToolkit().createExpandableComposite(composite, 512);
        FormData fd_xcRetenciones = new FormData();
        fd_xcRetenciones.left = new FormAttachment(0, 3);
        fd_xcRetenciones.bottom = new FormAttachment(0, 600);
        fd_xcRetenciones.top = new FormAttachment((Control)xcCompras, 10);
        this.xcRetenciones.setLayoutData((Object)fd_xcRetenciones);
        managedForm.getToolkit().paintBordersFor((Composite)this.xcRetenciones);
        this.xcRetenciones.setText("Retenciones en la Fuente  Impuesto a la Renta");
        Composite composite_1 = new Composite((Composite)this.xcRetenciones, 0);
        this.xcRetenciones.setClient((Control)composite_1);
        managedForm.getToolkit().adapt(composite_1);
        managedForm.getToolkit().paintBordersFor(composite_1);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabeceraAir = new Composite(composite_1, 0);
        cCabeceraAir.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(cCabeceraAir);
        managedForm.getToolkit().paintBordersFor(cCabeceraAir);
        GridLayout gl_cCabeceraAir = new GridLayout(1, false);
        gl_cCabeceraAir.marginWidth = 0;
        cCabeceraAir.setLayout((Layout)gl_cCabeceraAir);
        ToolBar toolBar_1 = new ToolBar(cCabeceraAir, 0x820000);
        managedForm.getToolkit().adapt((Composite)toolBar_1);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_1);
        this.tlINuevaRetencion = new ToolItem(toolBar_1, 0);
        this.tlINuevaRetencion.setText("Nuevo");
        this.tltEditarRetencion = new ToolItem(toolBar_1, 0);
        this.tltEditarRetencion.setText("Editar");
        this.tltEliminarRetencion = new ToolItem(toolBar_1, 0);
        this.tltEliminarRetencion.setText("Eliminar");
        this.tvRetenciones = new TableViewer(composite_1, 67584);
        this.tvRetenciones.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaginaCompras.this.detalleSeleccionado = (DetalleAirCompras)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
            }
        });
        this.table_1 = this.tvRetenciones.getTable();
        this.table_1.setLinesVisible(true);
        this.table_1.setHeaderVisible(true);
        this.table_1.setLayoutData((Object)"Center");
        managedForm.getToolkit().paintBordersFor((Composite)this.table_1);
        TableColumn tblclmnCodRetencin = new TableColumn(this.table_1, 0);
        tblclmnCodRetencin.setWidth(100);
        tblclmnCodRetencin.setText("Cod. Retenci\u00f3n");
        TableColumn tblclmnConceptoDeRetencin = new TableColumn(this.table_1, 0);
        tblclmnConceptoDeRetencin.setWidth(180);
        tblclmnConceptoDeRetencin.setText("Concepto de Retenci\u00f3n");
        TableColumn tblclmnBaseImponible_1 = new TableColumn(this.table_1, 0);
        tblclmnBaseImponible_1.setWidth(100);
        tblclmnBaseImponible_1.setText("Base Imponible");
        TableColumn tblclmnretencin = new TableColumn(this.table_1, 0);
        tblclmnretencin.setWidth(100);
        tblclmnretencin.setText("%Retenci\u00f3n");
        TableColumn tblclmnNewColumn = new TableColumn(this.table_1, 0);
        tblclmnNewColumn.setWidth(100);
        tblclmnNewColumn.setText("Valor Retenido");
        this.xcReembolsos = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xcReembolsos = new FormData();
        fd_xcReembolsos.bottom = new FormAttachment(0, 600);
        fd_xcReembolsos.top = new FormAttachment((Control)xcCompras, 10);
        fd_xcReembolsos.left = new FormAttachment((Control)this.xcRetenciones);
        this.xcReembolsos.setLayoutData((Object)fd_xcReembolsos);
        managedForm.getToolkit().paintBordersFor((Composite)this.xcReembolsos);
        this.xcReembolsos.setText("Reembolsos");
        Composite composite_2 = managedForm.getToolkit().createComposite((Composite)this.xcReembolsos, 0);
        managedForm.getToolkit().paintBordersFor(composite_2);
        this.xcReembolsos.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new BorderLayout(0, 0));
        Composite composite_3 = managedForm.getToolkit().createComposite(composite_2, 0);
        composite_3.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(composite_3);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginWidth = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        this.lblTotalReembolso = new Label(composite_3, 0);
        managedForm.getToolkit().adapt((Control)this.lblTotalReembolso, true, true);
        this.lblTotalReembolso.setText("Total Reembolsos");
        this.lblTotalReembolsos = new Label(composite_3, 0);
        GridData gd_lblTotalReembolsos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTotalReembolsos.widthHint = 50;
        this.lblTotalReembolsos.setLayoutData((Object)gd_lblTotalReembolsos);
        managedForm.getToolkit().adapt((Control)this.lblTotalReembolsos, true, true);
        this.lblTotalReembolsos.setText("0.0");
        ToolBar toolBar_2 = new ToolBar(composite_3, 0x820000);
        managedForm.getToolkit().adapt((Composite)toolBar_2);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_2);
        this.tlmNuevoReembolso = new ToolItem(toolBar_2, 0);
        this.tlmNuevoReembolso.setText("Nuevo");
        this.tlIEditarReembolso = new ToolItem(toolBar_2, 0);
        this.tlIEditarReembolso.setText("Editar");
        this.tliElminarReembolso = new ToolItem(toolBar_2, 0);
        this.tliElminarReembolso.setText("Eliminar");
        new Label(composite_3, 0);
        this.tvReembolsos = new TableViewer(composite_2, 67584);
        this.tvReembolsos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaCompras.this.reembolsoSelecionado = (Reembolso)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.table_2 = this.tvReembolsos.getTable();
        this.table_2.setLinesVisible(true);
        this.table_2.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.table_2);
        TableColumn tblclmnIdProveedor = new TableColumn(this.table_2, 0);
        tblclmnIdProveedor.setWidth(100);
        tblclmnIdProveedor.setText("Id Proveedor");
        TableColumn tblclmnTipoComprobante = new TableColumn(this.table_2, 0);
        tblclmnTipoComprobante.setWidth(150);
        tblclmnTipoComprobante.setText("Tipo Comprobante");
        TableColumn tblclmnAutorizacion = new TableColumn(this.table_2, 0);
        tblclmnAutorizacion.setWidth(100);
        tblclmnAutorizacion.setText("N\u00b0 Serie");
        TableColumn tblclmnBaseImponible = new TableColumn(this.table_2, 0);
        tblclmnBaseImponible.setWidth(100);
        tblclmnBaseImponible.setText("Base Imponible");
        AyudanteExpandableComposite.activar((ExpandableComposite)this.xcRetenciones, (boolean)false);
        AyudanteExpandableComposite.activar((ExpandableComposite)this.xcReembolsos, (boolean)false);
        this.m_bindingContext = this.initDataBindings();
        this.btnNuevoCompraClicked();
        this.btnEditarProveedorClicked();
        this.btnEditarComprobanteClicked();
        this.btnEditarValoresClicked();
        this.btnEditarPagoClicked();
        this.btnEditarFormasDePagoClicked();
        this.eliminarCompraClicked();
        this.btnNuevaRetencionClicked();
        this.btnEditarRetencionClicked();
        this.btnEliminarRetencionClicked();
        this.btnNuevoReembolsoClicked();
        this.btnEditarReembolsoClicked();
        this.btnEliminarReembolsoClicked();
        this.btnBuscarClicked();
    }

    private void tablaComprasSelectionChanged() {
        this.tvCompras.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaCompras.this.compraSeleccionada = (TransaccionCompra)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (PaginaCompras.this.compraSeleccionada != null) {
                    PaginaCompras.this.modeloDatos.setFechaRegistroContableSeleccionada(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getFechaRegistro());
                    PaginaCompras.this.activarSeccionRetenciones();
                    PaginaCompras.this.activarSeccionReembolsos();
                    PaginaCompras.this.reembolsoSelecionado = null;
                    PaginaCompras.this.detalleSeleccionado = null;
                    AyudanteViewer.seleccionarElemento((Viewer)PaginaCompras.this.tvRetenciones, null);
                    AyudanteViewer.seleccionarElemento((Viewer)PaginaCompras.this.tvReembolsos, null);
                }
            }
        });
    }

    private void activarSeccionReembolsos() {
        this.actualizarValorTotalReembolsosEnPantalla(this.compraSeleccionada);
        if (this.modeloDatos.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015()) {
            AyudanteExpandableComposite.activar((ExpandableComposite)this.xcReembolsos, (boolean)ComprobantesReembolso.comprobantesConReembolso_2013_FEB_2015.containsKey(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()));
        } else if (this.modeloDatos.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            AyudanteExpandableComposite.activar((ExpandableComposite)this.xcReembolsos, (boolean)ComprobantesReembolso.comprobantesConReembolso_DESDE_MAR_2015.containsKey(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()));
        }
    }

    private void activarSeccionRetenciones() {
        AyudanteExpandableComposite.activar((ExpandableComposite)this.xcRetenciones, (!ValidadorComprobantes.validarEsNotaCreditoReembolso(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante(), this.modeloDatos.periodo) || this.esPagoNoResidenteConComprobante41DesdeMarzo2015() ? 1 : 0) != 0);
    }

    private boolean esPagoNoResidenteConComprobante41DesdeMarzo2015() {
        return this.modeloDatos.periodo.isPeriodoDeAnexoDesdeMarzo2015() && ("41".equals(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()) || "47".equals(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()) || "48".equals(this.compraSeleccionada.getComprobanteCompra().getTipoComprobante())) && "02".equals(this.compraSeleccionada.getPagoLocalExterior().getFiscalidad().getTipoPago());
    }

    private void generarAlertaFiltro(String textoFiltro) {
        if (StringUtil.isNullOrEmpty((String)textoFiltro)) {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FOREGROUND);
            this.lblRegistros.setText(String.format("Total Registros: %d %s", this.modeloDatos.getTransaccionCompra().size(), "Compra(s)"));
        } else {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FILTRO);
            this.lblRegistros.setText(String.format("N\u00famero de registros filtrados: %d, de un total de %d %s", this.tvCompras.getTable().getItemCount(), this.modeloDatos.getTransaccionCompra().size(), "Compra(s)"));
        }
    }

    private void btnBuscarClicked() {
        this.btnBtnbuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaCompras.this.filtroCompras.setSearchText(PaginaCompras.this.txtIdentificacion.getText());
                PaginaCompras.this.tvCompras.refresh();
                PaginaCompras.this.generarAlertaFiltro(PaginaCompras.this.txtIdentificacion.getText());
            }
        });
    }

    private void btnEditarRetencionClicked() {
        this.tltEditarRetencion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.detalleSeleccionado != null) {
                    DetalleAirCompras copiaEdicion = PaginaCompras.this.detalleSeleccionado.crearCopiaEdicion();
                    copiaEdicion.setPropietario((ObjetoModelo)PaginaCompras.this.compraSeleccionada);
                    if (PaginaCompras.this.abrirDialogoRetencion(copiaEdicion, true, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo, PaginaCompras.this.modeloDatos.getDatosDeclaracion().getMicro(), PaginaCompras.this.modeloDatos.getFechaRegistroContableSeleccionada())) {
                        PaginaCompras.this.detalleSeleccionado.actualizarInformacion((DetalleAir)copiaEdicion);
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        PaginaCompras.this.tvRetenciones.refresh();
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado una retenci\u00f3n");
                }
            }
        });
    }

    private void btnEliminarRetencionClicked() {
        this.tltEliminarRetencion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.detalleSeleccionado != null && PaginaCompras.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaCompras.this.compraSeleccionada.elimanarDetalleAirCompras(PaginaCompras.this.detalleSeleccionado)) {
                    PaginaCompras.this.detalleSeleccionado = null;
                    PaginaCompras.this.tvRetenciones.refresh();
                    ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado una retenci\u00f3n");
                }
            }
        });
    }

    private void btnEliminarReembolsoClicked() {
        this.tliElminarReembolso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.reembolsoSelecionado != null && PaginaCompras.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?")) {
                    if (PaginaCompras.this.compraSeleccionada.eliminarReembolso(PaginaCompras.this.reembolsoSelecionado)) {
                        PaginaCompras.this.reembolsoSelecionado = null;
                        PaginaCompras.this.tvReembolsos.refresh();
                        PaginaCompras.this.actualizarValorTotalReembolsosEnPantalla(PaginaCompras.this.compraSeleccionada);
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    } else {
                        PaginaCompras.this.mostrarError("No se puede eliminar el Reembolso ya que la sumatoria de reembolsos final excede la sumatoria de bases imponibles del comprobante");
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un reembolso");
                }
            }
        });
    }

    private void actualizarValorTotalReembolsosEnPantalla(TransaccionCompra compraSeleccionada) {
        this.lblTotalReembolsos.setText(compraSeleccionada.getTotalReembolsos());
    }

    private void btnEditarReembolsoClicked() {
        this.tlIEditarReembolso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.reembolsoSelecionado != null) {
                    Reembolso copiaEdicion = PaginaCompras.this.reembolsoSelecionado.crearCopiaEdicion();
                    copiaEdicion.setCompraSeleccionada(PaginaCompras.this.compraSeleccionada.getComprobanteCompra());
                    PaginaCompras.this.reembolsoSelecionado.setPropietario((ObjetoModelo)PaginaCompras.this.compraSeleccionada);
                    if (PaginaCompras.this.abrirDialogoReembolso(copiaEdicion, true)) {
                        BigDecimal acumuladoReembolsos = PaginaCompras.this.compraSeleccionada.getTotalBasesReembolsos().add(copiaEdicion.getValoresComprobanteReembolso().getSumaBasesImponibles()).subtract(PaginaCompras.this.reembolsoSelecionado.getValoresComprobanteReembolso().getSumaBasesImponibles());
                        if (PaginaCompras.this.validarTotalReembolsos(acumuladoReembolsos)) {
                            PaginaCompras.this.reembolsoSelecionado.actualizarInformacion((Comprobante)copiaEdicion);
                            PaginaCompras.this.compraSeleccionada.setTotalBasesReembolsos(acumuladoReembolsos);
                            PaginaCompras.this.actualizarValorTotalReembolsosEnPantalla(PaginaCompras.this.compraSeleccionada);
                        }
                        PaginaCompras.this.tvReembolsos.refresh();
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un reembolso");
                }
            }
        });
    }

    private void btnEditarFormasDePagoClicked() {
        this.tltmEditarFormasDe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    if (PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getValoresComprovanteVenta().getFormasPago().isEmpty()) {
                        PaginaCompras.this.mostrarError("No existen formas de pago para editar");
                    } else {
                        TransaccionCompra copiaEdicion = new TransaccionCompra();
                        copiaEdicion.setComprobanteCompra(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().crearCopiaEdicion());
                        AsistenteEdicionCompras asistenteCompra = new AsistenteEdicionCompras(copiaEdicion, true, AsistenteEdicionCompras.Seccion.FORMAS_PAGO, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                        WizardDialog dialogoAsistenteEditCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                        if (dialogoAsistenteEditCompra.open() == 0) {
                            PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getValoresComprovanteVenta().actualizarInformacion((ValoresComprobante)copiaEdicion.getComprobanteCompra().getValoresComprovanteVenta());
                            ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        }
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compra para editar");
                }
            }
        });
    }

    private void btnEditarPagoClicked() {
        this.tltmEditarPagocomprobanteRetencion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    TransaccionCompra copiaEdicion = new TransaccionCompra();
                    copiaEdicion.setPropietario((ObjetoModelo)PaginaCompras.this.modeloDatos);
                    copiaEdicion.setComprobanteCompra(PaginaCompras.this.compraSeleccionada.getComprobanteCompra());
                    copiaEdicion.setPagoLocalExterior(PaginaCompras.this.compraSeleccionada.getPagoLocalExterior().crearCopiaEdicion());
                    copiaEdicion.setComprobanteRetencion(PaginaCompras.this.compraSeleccionada.getComprobanteRetencion().crearCopiaEdicion());
                    copiaEdicion.getComprobanteRetencion().setPropietario((ObjetoModelo)copiaEdicion);
                    AsistenteEdicionCompras asistenteCompra = new AsistenteEdicionCompras(copiaEdicion, true, AsistenteEdicionCompras.Seccion.LOCAL, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                    WizardDialog dialogoAsistenteEditCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                    if (dialogoAsistenteEditCompra.open() == 0) {
                        PaginaCompras.this.compraSeleccionada.getPagoLocalExterior().actualizarInformacion(copiaEdicion.getPagoLocalExterior());
                        PaginaCompras.this.compraSeleccionada.getComprobanteRetencion().actualizarInformacion((Comprobante)copiaEdicion.getComprobanteRetencion());
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compra para editar");
                }
            }
        });
    }

    private void btnEditarValoresClicked() {
        this.tltmEditarValores.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    TransaccionCompra copiaEdicion = new TransaccionCompra();
                    copiaEdicion.setComprobanteCompra(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().crearCopiaEdicion());
                    copiaEdicion.setPropietario((ObjetoModelo)PaginaCompras.this.modeloDatos);
                    AsistenteEdicionCompras asistenteCompra = new AsistenteEdicionCompras(copiaEdicion, true, AsistenteEdicionCompras.Seccion.VALORES, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                    WizardDialog dialogoAsistenteEditCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                    if (dialogoAsistenteEditCompra.open() == 0) {
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getValoresComprovanteVenta().actualizarInformacion((ValoresComprobante)copiaEdicion.getComprobanteCompra().getValoresComprovanteVenta());
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compra para editar");
                }
            }
        });
    }

    private void btnEditarComprobanteClicked() {
        this.tltmEditarComprobante.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    TransaccionCompra copiaEdicion = new TransaccionCompra();
                    copiaEdicion.getProveedor().setTipoIdentificacion(PaginaCompras.this.compraSeleccionada.getProveedor().getTipoIdentificacion());
                    copiaEdicion.getComprobanteCompra().setTipoSustento(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoSustento());
                    copiaEdicion.getComprobanteCompra().setDescripcionTipoSustento(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getDescripcionTipoSustento());
                    copiaEdicion.getComprobanteCompra().setTipoComprobante(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante());
                    copiaEdicion.getComprobanteCompra().setDescripcionTipoComprobante(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getDescripcionTipoComprobante());
                    copiaEdicion.getComprobanteCompra().setFechaRegistro(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getFechaRegistro());
                    copiaEdicion.getComprobanteCompra().setFechaEmision(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getFechaEmision());
                    copiaEdicion.getComprobanteCompra().setEstablecimiento(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getEstablecimiento());
                    copiaEdicion.getComprobanteCompra().setPuntoEmision(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getPuntoEmision());
                    copiaEdicion.getComprobanteCompra().setSecuencial(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getSecuencial());
                    copiaEdicion.getComprobanteCompra().setNumAutorizacion(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getNumAutorizacion());
                    copiaEdicion.getComprobanteCompra().setPropietario(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getPropietario());
                    copiaEdicion.getComprobanteModificado().setTipoComprobante(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getTipoComprobante());
                    copiaEdicion.getComprobanteModificado().setDescripcionTipoComprobante(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getDescripcionTipoComprobante());
                    copiaEdicion.getComprobanteModificado().setEstablecimiento(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getEstablecimiento());
                    copiaEdicion.getComprobanteModificado().setPuntoEmision(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getPuntoEmision());
                    copiaEdicion.getComprobanteModificado().setSecuencial(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getSecuencial());
                    copiaEdicion.getComprobanteModificado().setNumAutorizacion(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getNumAutorizacion());
                    copiaEdicion.getComprobanteModificado().setPropietario(PaginaCompras.this.compraSeleccionada.getComprobanteModificado().getPropietario());
                    copiaEdicion.setPropietario((ObjetoModelo)((Iva)PaginaCompras.this.compraSeleccionada.getPropietario()));
                    AsistenteEdicionCompras asistenteCompra = new AsistenteEdicionCompras(copiaEdicion, true, AsistenteEdicionCompras.Seccion.COMPROBANTE, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                    WizardDialog dialogoAsistenteEditCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                    if (dialogoAsistenteEditCompra.open() == 0) {
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setPropietario(copiaEdicion.getComprobanteCompra().getPropietario());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setTipoSustento(copiaEdicion.getComprobanteCompra().getTipoSustento());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setDescripcionTipoSustento(copiaEdicion.getComprobanteCompra().getDescripcionTipoSustento());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setTipoComprobante(copiaEdicion.getComprobanteCompra().getTipoComprobante());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setDescripcionTipoComprobante(copiaEdicion.getComprobanteCompra().getDescripcionTipoComprobante());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setFechaRegistro(copiaEdicion.getComprobanteCompra().getFechaRegistro());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setFechaEmision(copiaEdicion.getComprobanteCompra().getFechaEmision());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setEstablecimiento(copiaEdicion.getComprobanteCompra().getEstablecimiento());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setPuntoEmision(copiaEdicion.getComprobanteCompra().getPuntoEmision());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setSecuencial(copiaEdicion.getComprobanteCompra().getSecuencial());
                        PaginaCompras.this.compraSeleccionada.getComprobanteCompra().setNumAutorizacion(copiaEdicion.getComprobanteCompra().getNumAutorizacion());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setTipoComprobante(copiaEdicion.getComprobanteModificado().getTipoComprobante());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setDescripcionTipoComprobante(copiaEdicion.getComprobanteModificado().getDescripcionTipoComprobante());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setEstablecimiento(copiaEdicion.getComprobanteModificado().getEstablecimiento());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setPuntoEmision(copiaEdicion.getComprobanteModificado().getPuntoEmision());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setSecuencial(copiaEdicion.getComprobanteModificado().getSecuencial());
                        PaginaCompras.this.compraSeleccionada.getComprobanteModificado().setNumAutorizacion(copiaEdicion.getComprobanteModificado().getNumAutorizacion());
                        PaginaCompras.this.tvCompras.refresh();
                        boolean comprobanteModificado = false;
                        comprobanteModificado = "04".equals(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante());
                        boolean bl = comprobanteModificado = comprobanteModificado ? true : "05".equals(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante());
                        if (!comprobanteModificado) {
                            PaginaCompras.this.compraSeleccionada.getComprobanteModificado().reestablecer();
                        }
                        if ("41".equals(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante())) {
                            PaginaCompras.this.compraSeleccionada.getDetallesAirCompras().clear();
                        } else if ("04".equals(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante())) {
                            PaginaCompras.this.compraSeleccionada.getDetallesAirCompras().clear();
                            PaginaCompras.this.compraSeleccionada.getReembolsos().clear();
                            PaginaCompras.this.lblTotalReembolsos.setText("0.00");
                            PaginaCompras.this.compraSeleccionada.setTotalBasesReembolsos(BigDecimal.ZERO);
                        } else if (!"41".equals(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante())) {
                            PaginaCompras.this.compraSeleccionada.getReembolsos().clear();
                            PaginaCompras.this.lblTotalReembolsos.setText("0.00");
                            PaginaCompras.this.compraSeleccionada.setTotalBasesReembolsos(BigDecimal.ZERO);
                        }
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        PaginaCompras.this.tvReembolsos.refresh();
                        PaginaCompras.this.tvRetenciones.refresh();
                        AyudanteViewer.seleccionarElemento((Viewer)PaginaCompras.this.tvCompras, null);
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compra para editar");
                }
            }
        });
    }

    private void btnEditarProveedorClicked() {
        this.tltmEditarProveedor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    TransaccionCompra copiaEdicion = new TransaccionCompra();
                    copiaEdicion.setPropietario((ObjetoModelo)PaginaCompras.this.modeloDatos);
                    copiaEdicion.setProveedor(PaginaCompras.this.compraSeleccionada.getProveedor().crearCopiaEdicion());
                    AsistenteEdicionCompras asistenteCompra = new AsistenteEdicionCompras(copiaEdicion, true, AsistenteEdicionCompras.Seccion.PROVEEDOR, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                    WizardDialog dialogoAsistenteEditCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                    if (dialogoAsistenteEditCompra.open() == 0) {
                        PaginaCompras.this.compraSeleccionada.setProveedor(copiaEdicion.getProveedor());
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        PaginaCompras.this.tvCompras.refresh();
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compra para editar");
                }
            }
        });
    }

    private void btnNuevoReembolsoClicked() {
        this.tlmNuevoReembolso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    if (ComprobantesReembolso.comprobantesConReembolso_2013_FEB_2015.containsKey(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()) || ComprobantesReembolso.comprobantesConReembolso_DESDE_MAR_2015.containsKey(PaginaCompras.this.compraSeleccionada.getComprobanteCompra().getTipoComprobante()) && ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
                        BigDecimal acumuladoReembolsos;
                        Reembolso reembolso = new Reembolso();
                        reembolso.setPropietario((ObjetoModelo)PaginaCompras.this.compraSeleccionada);
                        reembolso.inicializar();
                        reembolso.setObligatorio(true);
                        reembolso.setCompraSeleccionada(PaginaCompras.this.compraSeleccionada.getComprobanteCompra());
                        if (PaginaCompras.this.abrirDialogoReembolso(reembolso, false) && PaginaCompras.this.validarTotalReembolsos(acumuladoReembolsos = PaginaCompras.this.compraSeleccionada.getTotalBasesReembolsos().add(PaginaCompras.this.calcularAcumuladoDeReembolsosPorTipoDeComprobante(reembolso)))) {
                            PaginaCompras.this.compraSeleccionada.agregarReembolsos(reembolso);
                            PaginaCompras.this.compraSeleccionada.setTotalBasesReembolsos(acumuladoReembolsos);
                            PaginaCompras.this.actualizarValorTotalReembolsosEnPantalla(PaginaCompras.this.compraSeleccionada);
                            ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        }
                    } else {
                        PaginaCompras.this.mostrarAdvertencia("No puede agregar un Reembolso a la compra");
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compras por proveedor");
                }
            }
        });
    }

    private BigDecimal calcularAcumuladoDeReembolsosPorTipoDeComprobante(Reembolso reembolso) {
        BigDecimal totalAcumulado = reembolso.getValoresComprobanteReembolso().getSumaBasesImponibles();
        if (ComprobantesReembolso.codigosComprobantesReembolsoResta.containsKey(reembolso.getTipoComprobanteReembolso())) {
            totalAcumulado = totalAcumulado.negate();
        }
        return totalAcumulado;
    }

    private boolean validarTotalReembolsos(BigDecimal acumuladoReembolsos) {
        if (this.modeloDatos.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            return this.compraSeleccionada.getComprobanteCompra().getValoresComprovanteVenta().getSumaBasesImponibles().compareTo(acumuladoReembolsos) >= 0;
        }
        return true;
    }

    private boolean abrirDialogoReembolso(Reembolso reembolso, boolean editando) {
        DialogoReembolso dialogo = new DialogoReembolso(this.getSite(), this.compraSeleccionada.getReembolsos(), this.compraSeleccionada.getTotalBasesReembolsos(), this.modeloDatos.periodo, editando);
        dialogo.setModeloDatos(reembolso);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void btnNuevaRetencionClicked() {
        this.tlINuevaRetencion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null) {
                    DetalleAirCompras detalleAir = new DetalleAirCompras();
                    detalleAir.setPropietario((ObjetoModelo)PaginaCompras.this.compraSeleccionada);
                    detalleAir.inicializar();
                    if (PaginaCompras.this.abrirDialogoRetencion(detalleAir, false, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo, PaginaCompras.this.modeloDatos.getDatosDeclaracion().getMicro(), PaginaCompras.this.modeloDatos.getFechaRegistroContableSeleccionada())) {
                        PaginaCompras.this.compraSeleccionada.agregarDetalleAirCompras(detalleAir);
                        ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                        PaginaCompras.this.tvRetenciones.refresh();
                    }
                } else {
                    PaginaCompras.this.mostrarAdvertencia("No ha seleccionado un registro de compras por proveedor");
                }
            }
        });
    }

    private boolean abrirDialogoRetencion(DetalleAirCompras modeloDatos, boolean editando, Periodo periodo, String esMicroEmpresa, Date fechaSeleccContable) {
        ArrayList<String> detallesExistentes = new ArrayList<String>();
        for (DetalleAirCompras air : this.compraSeleccionada.getDetallesAirCompras()) {
            detallesExistentes.add(air.getConceptoRetencion());
        }
        DialogoDetalleAirCompra dialogo = new DialogoDetalleAirCompra(this.getSite(), detallesExistentes, editando, periodo, esMicroEmpresa, fechaSeleccContable);
        dialogo.setModeloDatos(modeloDatos);
        dialogo.setCompraSeleccionada(this.compraSeleccionada);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void btnNuevoCompraClicked() {
        this.tltmNuevoCompra.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransaccionCompra compra = new TransaccionCompra();
                compra.setPropietario((ObjetoModelo)PaginaCompras.this.modeloDatos);
                AsistenteNuevaCompra asistenteCompra = new AsistenteNuevaCompra(compra, false, ((PaginaCompras)PaginaCompras.this).modeloDatos.periodo);
                WizardDialog dialogoAsistenteNuevaCompra = new WizardDialog(PaginaCompras.this.getSite().getShell(), (IWizard)asistenteCompra);
                if (dialogoAsistenteNuevaCompra.open() == 0) {
                    compra.getComprobanteCompra().getDescripcionTipoComprobante();
                    compra.getComprobanteCompra().getDescripcionTipoSustento();
                    PaginaCompras.this.modeloDatos.agregarTransaccionCompra(compra);
                    ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    PaginaCompras.this.generarAlertaFiltro(PaginaCompras.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void eliminarCompraClicked() {
        this.tltmEliminar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaCompras.this.compraSeleccionada != null && PaginaCompras.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaCompras.this.modeloDatos.eliminarTransaccionCompra(PaginaCompras.this.compraSeleccionada)) {
                    PaginaCompras.this.compraSeleccionada = null;
                    ((EditorATS)PaginaCompras.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaCompras.this.modeloDatos);
                    PaginaCompras.this.generarAlertaFiltro(PaginaCompras.this.txtIdentificacion.getText());
                }
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), TransaccionCompra.class, (String[])new String[]{"comprobanteCompra.descripcionTipoSustento", "proveedor.identificacion", "comprobanteCompra.descripcionTipoComprobante", "comprobanteCompra.serial", "comprobanteCompra.numAutorizacion", "comprobanteCompra.valoresComprovanteVenta.baseIvaCero", "comprobanteCompra.valoresComprovanteVenta.baseIvaNoCero", "comprobanteCompra.valoresComprovanteVenta.baseNoIva", "comprobanteCompra.valoresComprovanteVenta.montoIva"});
        this.tvCompras.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvCompras.setContentProvider((IContentProvider)listContentProvider);
        IObservableList transaccionCompraModeloDatosObserveList = BeanProperties.list((String)"transaccionCompra").observe((Object)this.modeloDatos);
        this.tvCompras.setInput((Object)transaccionCompraModeloDatosObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_2.getKnownElements(), Reembolso.class, (String[])new String[]{"proveedor.identificacion", "descripcionTipoComprobanteReembolso", "serial", "valoresComprobanteReembolso.sumaBasesImponiblesInterfaz"});
        this.tvReembolsos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_1));
        this.tvReembolsos.setContentProvider((IContentProvider)listContentProvider_2);
        IViewerObservableValue observeSingleSelectionTvCompras = ViewerProperties.singleSelection().observe((Viewer)this.tvCompras);
        IObservableList tvComprasReembolsosObserveDetailList = BeanProperties.list(TransaccionCompra.class, (String)"reembolsos", Reembolso.class).observeDetail((IObservableValue)observeSingleSelectionTvCompras);
        this.tvReembolsos.setInput((Object)tvComprasReembolsosObserveDetailList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_2 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), DetalleAirCompras.class, (String[])new String[]{"conceptoRetencion", "descripcionConcepto", "baseImponibleRenta", "porcentajeRetencion", "valorRetenido"});
        this.tvRetenciones.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_2));
        this.tvRetenciones.setContentProvider((IContentProvider)listContentProvider_1);
        IViewerObservableValue observeSingleSelectionTvCompras_1 = ViewerProperties.singleSelection().observe((Viewer)this.tvCompras);
        IObservableList tvComprasDetallesAirComprasObserveDetailList = BeanProperties.list(TransaccionCompra.class, (String)"detallesAirCompras", DetalleAirCompras.class).observeDetail((IObservableValue)observeSingleSelectionTvCompras_1);
        this.tvRetenciones.setInput((Object)tvComprasDetallesAirComprasObserveDetailList);
        ISWTObservableValue lblTotalReembolsoObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblTotalReembolso);
        IObservableValue modeloDatosMostrarReembolsosObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"mostrarReembolsos");
        bindingContext.bindValue((IObservableValue)lblTotalReembolsoObserveVisibleObserveWidget, modeloDatosMostrarReembolsosObserveValue, null, null);
        ISWTObservableValue lblTotalReembolsosObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblTotalReembolsos);
        bindingContext.bindValue((IObservableValue)lblTotalReembolsosObserveVisibleObserveWidget, modeloDatosMostrarReembolsosObserveValue, null, null);
        return bindingContext;
    }
}

